/* =========================================================
   Overlays Plugin — logic (v1)
   File: addons/overlays.logic.js
========================================================= */
(function(){
  "use strict";

  const LS_KEY = "cp_overlays_v1";
  const LS_ACTIVE = "cp_overlays_active_v1";

  const safeJSON = (s, fb)=>{ try{ return JSON.parse(s); }catch(_){ return fb; } };
  const lsGet = (k, fb)=>{ try{ const v = localStorage.getItem(k); return v==null?fb:v; }catch(_){ return fb; } };
  const lsSet = (k, v)=>{ try{ localStorage.setItem(k, v); }catch(_){ } };

  function uid(){ return "ov_" + Math.random().toString(16).slice(2,10) + "_" + Date.now().toString(16); }

  function defaults(){
    return [
      { id:"lower3", type:"lowerthird", name:"Lower Third", enabled:false, text:"Guest Name", subtext:"Title / Role", pos:"bl", style:{ accent:"#4aa3ff" } },
      { id:"ticker", type:"ticker", name:"Ticker", enabled:false, text:"Breaking: …", speed: 1.0, pos:"b", style:{ accent:"#ffd050" } },
      { id:"bug", type:"bug", name:"Logo Bug", enabled:false, text:"ITAHUKA", pos:"tr", style:{ accent:"#20c997" } }
    ];
  }

  function load(){
    const raw = lsGet(LS_KEY, "");
    const list = safeJSON(raw, null);
    if (Array.isArray(list) && list.length) return list;
    const d = defaults();
    save(d);
    return d;
  }

  function save(list){
    const cleaned = (Array.isArray(list)?list:[]).map(o=>{
      const x = Object.assign({}, o);
      x.id = String(x.id || uid()).trim();
      x.type = String(x.type || "custom").trim();
      x.name = String(x.name || x.type).trim();
      x.enabled = !!x.enabled;
      x.text = String(x.text || "");
      x.subtext = String(x.subtext || "");
      x.pos = String(x.pos || "bl");
      x.speed = Number.isFinite(+x.speed) ? +x.speed : 1.0;
      x.style = (x.style && typeof x.style === "object") ? x.style : {};
      return x;
    }).filter(o=>o.id && o.type);
    lsSet(LS_KEY, JSON.stringify(cleaned));
    return cleaned;
  }

  function activeIds(){
    const raw = lsGet(LS_ACTIVE, "");
    const ids = safeJSON(raw, null);
    if (Array.isArray(ids)) return ids.map(String);
    return [];
  }

  function setActive(ids){
    const list = (Array.isArray(ids)?ids:[]).map(String);
    lsSet(LS_ACTIVE, JSON.stringify(list));
    return list;
  }

  function payload(){
    const list = load();
    const ids = new Set(activeIds());
    const active = list.filter(o=>o.enabled || ids.has(o.id));
    return {
      version: 1,
      updatedAt: Date.now(),
      overlays: active.map(o=>({
        id:o.id, type:o.type, name:o.name,
        text:o.text, subtext:o.subtext,
        pos:o.pos, speed:o.speed,
        style:o.style || {}
      }))
    };
  }

  window.CPOverlays = { load, save, activeIds, setActive, payload, uid };
})();
