/* =========================================================
   Virtuals Plugin — logic (v1)
   File: addons/virtuals.logic.js
========================================================= */
(function(){
  "use strict";

  const LS_KEY = "cp_virtuals_v1";
  const safeJSON = (s, fb)=>{ try{ return JSON.parse(s); }catch(_){ return fb; } };
  const lsGet = (k, fb)=>{ try{ const v = localStorage.getItem(k); return v==null?fb:v; }catch(_){ return fb; } };
  const lsSet = (k, v)=>{ try{ localStorage.setItem(k, v); }catch(_){ } };

  function defaults(){ return { version:1, mode:"none", blur: 8, imageDataUrl:"", target:"local" }; }

  function load(){
    const raw = lsGet(LS_KEY, "");
    const obj = safeJSON(raw, null);
    if (obj && typeof obj === "object") return Object.assign(defaults(), obj);
    const d = defaults(); save(d); return d;
  }

  function save(obj){
    const cur = Object.assign(defaults(), obj || {});
    cur.mode = ["none","blur","image"].includes(cur.mode) ? cur.mode : "none";
    cur.blur = Math.max(0, Math.min(40, parseInt(cur.blur,10) || 0));
    cur.imageDataUrl = String(cur.imageDataUrl || "");
    cur.target = String(cur.target || "local");
    lsSet(LS_KEY, JSON.stringify(cur));
    return cur;
  }

  function payload(){
    const cur = load();
    return { version:1, updatedAt: Date.now(), virtuals: cur };
  }

  window.CPVirtuals = { load, save, payload };
})();
