/* =========================================================
   Transitions Plugin — logic (v1)
   File: addons/transitions.logic.js
========================================================= */
(function(){
  "use strict";

  const LS_KEY = "cp_transitions_v1";
  const safeJSON = (s, fb)=>{ try{ return JSON.parse(s); }catch(_){ return fb; } };
  const lsGet = (k, fb)=>{ try{ const v = localStorage.getItem(k); return v==null?fb:v; }catch(_){ return fb; } };
  const lsSet = (k, v)=>{ try{ localStorage.setItem(k, v); }catch(_){ } };

  function defaults(){
    return { version: 1, defaultKind: "cut", fadeMs: 450, stingerUrl: "", last: null };
  }

  function load(){
    const raw = lsGet(LS_KEY, "");
    const obj = safeJSON(raw, null);
    if (obj && typeof obj === "object") return Object.assign(defaults(), obj);
    const d = defaults(); save(d); return d;
  }

  function save(obj){
    const cur = Object.assign(defaults(), obj || {});
    cur.fadeMs = Math.max(0, Math.min(5000, parseInt(cur.fadeMs, 10) || 0));
    cur.defaultKind = ["cut","fade","stinger"].includes(cur.defaultKind) ? cur.defaultKind : "cut";
    cur.stingerUrl = String(cur.stingerUrl || "");
    lsSet(LS_KEY, JSON.stringify(cur));
    return cur;
  }

  function command(kind, opts){
    const cfg = load();
    const k = kind || cfg.defaultKind || "cut";
    const payload = {
      version: 1,
      at: Date.now(),
      kind: k,
      fadeMs: (opts && opts.fadeMs != null) ? opts.fadeMs : cfg.fadeMs,
      stingerUrl: (opts && opts.stingerUrl != null) ? opts.stingerUrl : cfg.stingerUrl
    };
    cfg.last = payload;
    save(cfg);
    return payload;
  }

  function endpoints(){
    const w = (window.CP_TRANSITIONS_ENDPOINTS && typeof window.CP_TRANSITIONS_ENDPOINTS === "object") ? window.CP_TRANSITIONS_ENDPOINTS : null;
    return { take: (w && w.take) || "" };
  }

  async function postTake(payload){
    const ep = endpoints().take;
    if (!ep) return { ok:false, skipped:true };
    const res = await fetch(ep, {
      method:"POST",
      headers:{ "Content-Type":"application/json" },
      credentials:"same-origin",
      body: JSON.stringify(payload || {})
    });
    const txt = await res.text().catch(()=> "");
    const data = safeJSON(txt, null) || { raw: txt };
    if (!res.ok) throw new Error((data && (data.error||data.message)) || (res.status + " " + res.statusText));
    return data;
  }

  window.CPTransitions = { load, save, command, postTake };
})();
