/* =========================================================
   Program Renderer Bridge — OPTIONAL helper
   File: addons/renderer_bridge.js

   Include this in your PROGRAM RENDERER page (preview/program compositor)
   to receive plugin commands from the co-producer page.

   Message formats received via postMessage:
     { type:"cp:overlays:set", payload:{...} }
     { type:"cp:transition:run", payload:{...} }
     { type:"cp:virtuals:set", payload:{...} }

   Replace applyOverlays/applyVirtuals/runTransition with your compositor logic.
========================================================= */
(function(){
  "use strict";
  const log = (...a)=>console.log("[renderer_bridge]", ...a);

  function applyOverlays(payload){ log("applyOverlays", payload); window.__CP_OVERLAYS__ = payload; }
  function applyVirtuals(payload){ log("applyVirtuals", payload); window.__CP_VIRTUALS__ = payload; }
  function runTransition(payload){ log("runTransition", payload); window.__CP_TRANSITION__ = payload; }

  window.addEventListener("message", (ev)=>{
    const msg = ev.data;
    if (!msg || typeof msg !== "object") return;
    if (msg.type === "cp:overlays:set") applyOverlays(msg.payload || {});
    if (msg.type === "cp:virtuals:set") applyVirtuals(msg.payload || {});
    if (msg.type === "cp:transition:run") runTransition(msg.payload || {});
  });

  log("ready");
})();
